
package com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the DNS    RI.
 * DNS    RI 2.2.4-b01
 * Generated source version: 2.2
 * 
 */
@WebService(name = "SchedulingSvcSoap", targetNamespace = "http://DNS        /SchedulingSvc")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface SchedulingSvcSoap {


    /**
     * Get all possible cancellation reasons for the logged-in site
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedCancellationReasonsArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getCancellationReasons")
    @WebResult(name = "getCancellationReasonsResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getCancellationReasons", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetCancellationReasons")
    @ResponseWrapper(localName = "getCancellationReasonsResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetCancellationReasonsResponse")
    public TaggedCancellationReasonsArray getCancellationReasons();

    /**
     * Get all possible cancellation reasons for the logged-in site
     * 
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedCancellationReasonsArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getVeteranCancellationReasons")
    @WebResult(name = "getVeteranCancellationReasonsResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getVeteranCancellationReasons", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranCancellationReasons")
    @ResponseWrapper(localName = "getVeteranCancellationReasonsResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranCancellationReasonsResponse")
    public TaggedCancellationReasonsArray getVeteranCancellationReasons(
        @WebParam(name = "siteId", targetNamespace = "http://DNS        /SchedulingSvc")
        String siteId,
        @WebParam(name = "mpiPid", targetNamespace = "http://DNS        /SchedulingSvc")
        String mpiPid,
        @WebParam(name = "multiSite", targetNamespace = "http://DNS        /SchedulingSvc")
        boolean multiSite);

    /**
     * Check logged in user's access to clinic
     * 
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.BoolTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/hasClinicAccess")
    @WebResult(name = "hasClinicAccessResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "hasClinicAccess", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.HasClinicAccess")
    @ResponseWrapper(localName = "hasClinicAccessResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.HasClinicAccessResponse")
    public BoolTO hasClinicAccess(
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId);

    /**
     * Get list of clinics
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getClinics")
    @WebResult(name = "getClinicsResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getClinics", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinics")
    @ResponseWrapper(localName = "getClinicsResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinicsResponse")
    public TaggedHospitalLocationArray getClinics(
        @WebParam(name = "target", targetNamespace = "http://DNS        /SchedulingSvc")
        String target);

    /**
     * Get list of appointment types
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTypeArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getAppointmentTypes")
    @WebResult(name = "getAppointmentTypesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getAppointmentTypes", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetAppointmentTypes")
    @ResponseWrapper(localName = "getAppointmentTypesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetAppointmentTypesResponse")
    public AppointmentTypeArray getAppointmentTypes(
        @WebParam(name = "target", targetNamespace = "http://DNS        /SchedulingSvc")
        String target);

    /**
     * Make an appointment for a patient
     * 
     * @param desiredDateTime
     * @param ekg
     * @param lvl
     * @param purposeSubcategory
     * @param bookNotes
     * @param appointmentTimestamp
     * @param appointmentLength
     * @param purpose
     * @param xRay
     * @param lab
     * @param appointmentType
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/makeAppointment")
    @WebResult(name = "makeAppointmentResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "makeAppointment", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.MakeAppointment")
    @ResponseWrapper(localName = "makeAppointmentResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.MakeAppointmentResponse")
    public AppointmentTO makeAppointment(
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "appointmentTimestamp", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentTimestamp,
        @WebParam(name = "purpose", targetNamespace = "http://DNS        /SchedulingSvc")
        String purpose,
        @WebParam(name = "purposeSubcategory", targetNamespace = "http://DNS        /SchedulingSvc")
        String purposeSubcategory,
        @WebParam(name = "appointmentLength", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentLength,
        @WebParam(name = "appointmentType", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentType,
        @WebParam(name = "bookNotes", targetNamespace = "http://DNS        /SchedulingSvc")
        String bookNotes,
        @WebParam(name = "Lab", targetNamespace = "http://DNS        /SchedulingSvc")
        String lab,
        @WebParam(name = "XRay", targetNamespace = "http://DNS        /SchedulingSvc")
        String xRay,
        @WebParam(name = "EKG", targetNamespace = "http://DNS        /SchedulingSvc")
        String ekg,
        @WebParam(name = "Lvl", targetNamespace = "http://DNS        /SchedulingSvc")
        String lvl,
        @WebParam(name = "desiredDateTime", targetNamespace = "http://DNS        /SchedulingSvc")
        String desiredDateTime);

    /**
     * Veteran can make a appointment
     * 
     * @param ekg
     * @param multiSite
     * @param mpiPid
     * @param appointmentLength
     * @param purpose
     * @param xRay
     * @param lab
     * @param desiredDateTime
     * @param lvl
     * @param purposeSubcategory
     * @param siteId
     * @param appointmentTimestamp
     * @param bookNotes
     * @param appointmentType
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AppointmentTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/makeVeteranAppointment")
    @WebResult(name = "makeVeteranAppointmentResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "makeVeteranAppointment", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.MakeVeteranAppointment")
    @ResponseWrapper(localName = "makeVeteranAppointmentResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.MakeVeteranAppointmentResponse")
    public AppointmentTO makeVeteranAppointment(
        @WebParam(name = "siteId", targetNamespace = "http://DNS        /SchedulingSvc")
        String siteId,
        @WebParam(name = "mpiPid", targetNamespace = "http://DNS        /SchedulingSvc")
        String mpiPid,
        @WebParam(name = "multiSite", targetNamespace = "http://DNS        /SchedulingSvc")
        boolean multiSite,
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "appointmentTimestamp", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentTimestamp,
        @WebParam(name = "purpose", targetNamespace = "http://DNS        /SchedulingSvc")
        String purpose,
        @WebParam(name = "purposeSubcategory", targetNamespace = "http://DNS        /SchedulingSvc")
        String purposeSubcategory,
        @WebParam(name = "appointmentLength", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentLength,
        @WebParam(name = "appointmentType", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentType,
        @WebParam(name = "bookNotes", targetNamespace = "http://DNS        /SchedulingSvc")
        String bookNotes,
        @WebParam(name = "Lab", targetNamespace = "http://DNS        /SchedulingSvc")
        String lab,
        @WebParam(name = "XRay", targetNamespace = "http://DNS        /SchedulingSvc")
        String xRay,
        @WebParam(name = "EKG", targetNamespace = "http://DNS        /SchedulingSvc")
        String ekg,
        @WebParam(name = "Lvl", targetNamespace = "http://DNS        /SchedulingSvc")
        String lvl,
        @WebParam(name = "desiredDateTime", targetNamespace = "http://DNS        /SchedulingSvc")
        String desiredDateTime);

    /**
     * Get a list of patients by clinic
     * 
     * @param startDate
     * @param stopDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.PatientArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getPatientsByClinic")
    @WebResult(name = "getPatientsByClinicResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getPatientsByClinic", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetPatientsByClinic")
    @ResponseWrapper(localName = "getPatientsByClinicResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetPatientsByClinicResponse")
    public PatientArray getPatientsByClinic(
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "startDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String startDate,
        @WebParam(name = "stopDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String stopDate);

    /**
     * Get Electronic Wait List (EWL) by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedEwlStatusArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getEwlByPatient")
    @WebResult(name = "getEwlByPatientResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getEwlByPatient", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetEwlByPatient")
    @ResponseWrapper(localName = "getEwlByPatientResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetEwlByPatientResponse")
    public TaggedEwlStatusArrays getEwlByPatient();

    /**
     * Get Near list by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedNearListByFacilityArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getNearListByFacility")
    @WebResult(name = "getNearListByFacilityResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getNearListByFacility", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetNearListByFacility")
    @ResponseWrapper(localName = "getNearListByFacilityResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetNearListByFacilityResponse")
    public TaggedNearListByFacilityArrays getNearListByFacility();

    /**
     * Get Near list by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedNearListByPatientArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getNearListByPatient")
    @WebResult(name = "getNearListByPatientResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getNearListByPatient", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetNearListByPatient")
    @ResponseWrapper(localName = "getNearListByPatientResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetNearListByPatientResponse")
    public TaggedNearListByPatientArrays getNearListByPatient();

    /**
     * Get Recall List by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedRecallListByFacilityArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getRecallListByFacility")
    @WebResult(name = "getRecallListByFacilityResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getRecallListByFacility", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetRecallListByFacility")
    @ResponseWrapper(localName = "getRecallListByFacilityResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetRecallListByFacilityResponse")
    public TaggedRecallListByFacilityArrays getRecallListByFacility();

    /**
     * Get Electronic Wait List (EWL) by Facility
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedEwlByFacilityArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getEwlByFacility")
    @WebResult(name = "getEwlByFacilityResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getEwlByFacility", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetEwlByFacility")
    @ResponseWrapper(localName = "getEwlByFacilityResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetEwlByFacilityResponse")
    public TaggedEwlByFacilityArrays getEwlByFacility();

    /**
     * Cancel an appointment for a patient
     * 
     * @param appointmentTimestamp
     * @param cancelreason
     * @param remarks
     * @param cancelCode
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/cancelAppointment")
    @WebResult(name = "cancelAppointmentResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "cancelAppointment", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointment")
    @ResponseWrapper(localName = "cancelAppointmentResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentResponse")
    public CancelAppointmentTO cancelAppointment(
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "appointmentTimestamp", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentTimestamp,
        @WebParam(name = "cancelCode", targetNamespace = "http://DNS        /SchedulingSvc")
        String cancelCode,
        @WebParam(name = "cancelreason", targetNamespace = "http://DNS        /SchedulingSvc")
        String cancelreason,
        @WebParam(name = "remarks", targetNamespace = "http://DNS        /SchedulingSvc")
        String remarks);

    /**
     * Cancel veteran's appointment
     * 
     * @param appointmentTimestamp
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @param cancelreason
     * @param remarks
     * @param cancelCode
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/cancelVeteranAppointment")
    @WebResult(name = "cancelVeteranAppointmentResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "cancelVeteranAppointment", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelVeteranAppointment")
    @ResponseWrapper(localName = "cancelVeteranAppointmentResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelVeteranAppointmentResponse")
    public CancelAppointmentTO cancelVeteranAppointment(
        @WebParam(name = "siteId", targetNamespace = "http://DNS        /SchedulingSvc")
        String siteId,
        @WebParam(name = "mpiPid", targetNamespace = "http://DNS        /SchedulingSvc")
        String mpiPid,
        @WebParam(name = "multiSite", targetNamespace = "http://DNS        /SchedulingSvc")
        boolean multiSite,
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "appointmentTimestamp", targetNamespace = "http://DNS        /SchedulingSvc")
        String appointmentTimestamp,
        @WebParam(name = "cancelCode", targetNamespace = "http://DNS        /SchedulingSvc")
        String cancelCode,
        @WebParam(name = "cancelreason", targetNamespace = "http://DNS        /SchedulingSvc")
        String cancelreason,
        @WebParam(name = "remarks", targetNamespace = "http://DNS        /SchedulingSvc")
        String remarks);

    /**
     * Get a patient's pending appointments with booking notes.
     * 
     * @param fromDate
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedAppointmentArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getAppointmentsBookingNotes")
    @WebResult(name = "getAppointmentsBookingNotesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getAppointmentsBookingNotes", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetAppointmentsBookingNotes")
    @ResponseWrapper(localName = "getAppointmentsBookingNotesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetAppointmentsBookingNotesResponse")
    public TaggedAppointmentArray getAppointmentsBookingNotes(
        @WebParam(name = "fromDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String fromDate);

    /**
     * Get veteran's pending appointments with booking notes.
     * 
     * @param fromDate
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedAppointmentArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getVeteranAppointmentsBookingNotes")
    @WebResult(name = "getVeteranAppointmentsBookingNotesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getVeteranAppointmentsBookingNotes", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranAppointmentsBookingNotes")
    @ResponseWrapper(localName = "getVeteranAppointmentsBookingNotesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranAppointmentsBookingNotesResponse")
    public TaggedAppointmentArray getVeteranAppointmentsBookingNotes(
        @WebParam(name = "siteId", targetNamespace = "http://DNS        /SchedulingSvc")
        String siteId,
        @WebParam(name = "mpiPid", targetNamespace = "http://DNS        /SchedulingSvc")
        String mpiPid,
        @WebParam(name = "multiSite", targetNamespace = "http://DNS        /SchedulingSvc")
        boolean multiSite,
        @WebParam(name = "fromDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String fromDate);

    /**
     * Get clinic scheduling information, e.g., availability, default appointment length, etc.<br />clinicId is required. startDate and endDate are optional.<br />If dates are used, they should be in the form yyyymmdd.hhmmss (.hhmmss may be omitted if not needed).
     * 
     * @param startDate
     * @param endDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getClinicSchedulingDetailsByDateRange")
    @WebResult(name = "getClinicSchedulingDetailsByDateRangeResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getClinicSchedulingDetailsByDateRange", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinicSchedulingDetailsByDateRange")
    @ResponseWrapper(localName = "getClinicSchedulingDetailsByDateRangeResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinicSchedulingDetailsByDateRangeResponse")
    public TaggedHospitalLocationArray getClinicSchedulingDetailsByDateRange(
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "startDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String startDate,
        @WebParam(name = "endDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String endDate);

    /**
     * Get clinic scheduling information, e.g., availability, default appointment length, etc.<br />clinicId is required. startDate and endDate are optional.<br />If dates are used, they should be in the form yyyymmdd.hhmmss (.hhmmss may be omitted if not needed).
     * 
     * @param startDate
     * @param multiSite
     * @param siteId
     * @param mpiPid
     * @param endDate
     * @param clinicId
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getVeteranClinicSchedulingDetailsByDateRange")
    @WebResult(name = "getVeteranClinicSchedulingDetailsByDateRangeResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getVeteranClinicSchedulingDetailsByDateRange", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranClinicSchedulingDetailsByDateRange")
    @ResponseWrapper(localName = "getVeteranClinicSchedulingDetailsByDateRangeResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVeteranClinicSchedulingDetailsByDateRangeResponse")
    public TaggedHospitalLocationArray getVeteranClinicSchedulingDetailsByDateRange(
        @WebParam(name = "siteId", targetNamespace = "http://DNS        /SchedulingSvc")
        String siteId,
        @WebParam(name = "mpiPid", targetNamespace = "http://DNS        /SchedulingSvc")
        String mpiPid,
        @WebParam(name = "multiSite", targetNamespace = "http://DNS        /SchedulingSvc")
        boolean multiSite,
        @WebParam(name = "clinicId", targetNamespace = "http://DNS        /SchedulingSvc")
        String clinicId,
        @WebParam(name = "startDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String startDate,
        @WebParam(name = "endDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String endDate);

    /**
     * Get all clinics for the logged-in site, including specialties
     * 
     * @param target
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedHospitalLocationArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getClinicsWithSpecialties")
    @WebResult(name = "getClinicsWithSpecialtiesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getClinicsWithSpecialties", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinicsWithSpecialties")
    @ResponseWrapper(localName = "getClinicsWithSpecialtiesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetClinicsWithSpecialtiesResponse")
    public TaggedHospitalLocationArray getClinicsWithSpecialties(
        @WebParam(name = "target", targetNamespace = "http://DNS        /SchedulingSvc")
        String target);

    /**
     * Get Recall list by Patient
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedRecallListByPatientArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getRecallListByPatient")
    @WebResult(name = "getRecallListByPatientResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getRecallListByPatient", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetRecallListByPatient")
    @ResponseWrapper(localName = "getRecallListByPatientResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetRecallListByPatientResponse")
    public TaggedRecallListByPatientArrays getRecallListByPatient();

    /**
     * Remove Patient from Electronic Waiting List (EWL)
     * 
     * @param sdwlData
     * @param disp
     * @param sdwlien
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TextTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/removePatientFromEwl")
    @WebResult(name = "removePatientFromEwlResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "removePatientFromEwl", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.RemovePatientFromEwl")
    @ResponseWrapper(localName = "removePatientFromEwlResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.RemovePatientFromEwlResponse")
    public TextTO removePatientFromEwl(
        @WebParam(name = "SDWLIEN", targetNamespace = "http://DNS        /SchedulingSvc")
        String sdwlien,
        @WebParam(name = "Disp", targetNamespace = "http://DNS        /SchedulingSvc")
        String disp,
        @WebParam(name = "SDWLData", targetNamespace = "http://DNS        /SchedulingSvc")
        String sdwlData);

    /**
     * Update Near List
     * 
     * @param status
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedUpdateNearListArrays
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/updateNearList")
    @WebResult(name = "updateNearListResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "updateNearList", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.UpdateNearList")
    @ResponseWrapper(localName = "updateNearListResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.UpdateNearListResponse")
    public TaggedUpdateNearListArrays updateNearList(
        @WebParam(name = "Status", targetNamespace = "http://DNS        /SchedulingSvc")
        String status);

    /**
     * Add patient to Electronic Wait List (EWL)
     * 
     * @param enrolleeDateUsed
     * @param enrolleeDatabaseFile
     * @param waitListType
     * @param enrolleeStatus
     * @param desiredApptDate
     * @param provider
     * @param priority
     * @param changedClinicParentPointer
     * @param pointer
     * @param svcConnectedPriority
     * @param comment
     * @param schedulingReminderFlag
     * @param institution
     * @param requestedBy
     * @param svcConnectedPct
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TextTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/addPatientToEwl")
    @WebResult(name = "addPatientToEwlResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "addPatientToEwl", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AddPatientToEwl")
    @ResponseWrapper(localName = "addPatientToEwlResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AddPatientToEwlResponse")
    public TextTO addPatientToEwl(
        @WebParam(name = "waitListType", targetNamespace = "http://DNS        /SchedulingSvc")
        String waitListType,
        @WebParam(name = "institution", targetNamespace = "http://DNS        /SchedulingSvc")
        String institution,
        @WebParam(name = "pointer", targetNamespace = "http://DNS        /SchedulingSvc")
        String pointer,
        @WebParam(name = "priority", targetNamespace = "http://DNS        /SchedulingSvc")
        String priority,
        @WebParam(name = "requestedBy", targetNamespace = "http://DNS        /SchedulingSvc")
        String requestedBy,
        @WebParam(name = "provider", targetNamespace = "http://DNS        /SchedulingSvc")
        String provider,
        @WebParam(name = "svcConnectedPct", targetNamespace = "http://DNS        /SchedulingSvc")
        String svcConnectedPct,
        @WebParam(name = "svcConnectedPriority", targetNamespace = "http://DNS        /SchedulingSvc")
        String svcConnectedPriority,
        @WebParam(name = "desiredApptDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String desiredApptDate,
        @WebParam(name = "comment", targetNamespace = "http://DNS        /SchedulingSvc")
        String comment,
        @WebParam(name = "enrolleeStatus", targetNamespace = "http://DNS        /SchedulingSvc")
        String enrolleeStatus,
        @WebParam(name = "enrolleeDateUsed", targetNamespace = "http://DNS        /SchedulingSvc")
        String enrolleeDateUsed,
        @WebParam(name = "enrolleeDatabaseFile", targetNamespace = "http://DNS        /SchedulingSvc")
        String enrolleeDatabaseFile,
        @WebParam(name = "schedulingReminderFlag", targetNamespace = "http://DNS        /SchedulingSvc")
        String schedulingReminderFlag,
        @WebParam(name = "changedClinicParentPointer", targetNamespace = "http://DNS        /SchedulingSvc")
        String changedClinicParentPointer);

    /**
     * Get all possible consult statuses
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultStatusesArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getConsultStatuses")
    @WebResult(name = "getConsultStatusesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getConsultStatuses", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultStatuses")
    @ResponseWrapper(localName = "getConsultStatusesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultStatusesResponse")
    public TaggedConsultStatusesArray getConsultStatuses();

    /**
     * Get all possible consulting services
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultingServicesArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getConsultingServices")
    @WebResult(name = "getConsultingServicesResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getConsultingServices", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultingServices")
    @ResponseWrapper(localName = "getConsultingServicesResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultingServicesResponse")
    public TaggedConsultingServicesArray getConsultingServices();

    /**
     * Get consults by a combination of service, provider, and status
     * 
     * @param startDate
     * @param service
     * @param provider
     * @param endDate
     * @param statuses
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultsArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getConsultsWithoutPatient")
    @WebResult(name = "getConsultsWithoutPatientResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getConsultsWithoutPatient", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultsWithoutPatient")
    @ResponseWrapper(localName = "getConsultsWithoutPatientResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultsWithoutPatientResponse")
    public TaggedConsultsArray getConsultsWithoutPatient(
        @WebParam(name = "startDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String startDate,
        @WebParam(name = "endDate", targetNamespace = "http://DNS        /SchedulingSvc")
        String endDate,
        @WebParam(name = "service", targetNamespace = "http://DNS        /SchedulingSvc")
        String service,
        @WebParam(name = "statuses", targetNamespace = "http://DNS        /SchedulingSvc")
        String statuses,
        @WebParam(name = "provider", targetNamespace = "http://DNS        /SchedulingSvc")
        String provider);

    /**
     * Get detailed report for a particular consult
     * 
     * @param consultIen
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedConsultDetailArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getConsultDetails")
    @WebResult(name = "getConsultDetailsResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getConsultDetails", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultDetails")
    @ResponseWrapper(localName = "getConsultDetailsResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetConsultDetailsResponse")
    public TaggedConsultDetailArray getConsultDetails(
        @WebParam(name = "consultIen", targetNamespace = "http://DNS        /SchedulingSvc")
        String consultIen);

    /**
     * Add a data source for this session
     * 
     * @param region
     * @param port
     * @param id
     * @param protocol
     * @param name
     * @param modality
     * @param datasource
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SiteTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/addDataSource")
    @WebResult(name = "addDataSourceResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "addDataSource", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AddDataSource")
    @ResponseWrapper(localName = "addDataSourceResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AddDataSourceResponse")
    public SiteTO addDataSource(
        @WebParam(name = "id", targetNamespace = "http://DNS        /SchedulingSvc")
        String id,
        @WebParam(name = "name", targetNamespace = "http://DNS        /SchedulingSvc")
        String name,
        @WebParam(name = "datasource", targetNamespace = "http://DNS        /SchedulingSvc")
        String datasource,
        @WebParam(name = "port", targetNamespace = "http://DNS        /SchedulingSvc")
        String port,
        @WebParam(name = "modality", targetNamespace = "http://DNS        /SchedulingSvc")
        String modality,
        @WebParam(name = "protocol", targetNamespace = "http://DNS        /SchedulingSvc")
        String protocol,
        @WebParam(name = "region", targetNamespace = "http://DNS        /SchedulingSvc")
        String region);

    /**
     * Set the current session's sites file
     * 
     * @param sitesFileName
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SiteArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/setVha")
    @WebResult(name = "setVhaResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "setVha", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SetVha")
    @ResponseWrapper(localName = "setVhaResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SetVhaResponse")
    public SiteArray setVha(
        @WebParam(name = "sitesFileName", targetNamespace = "http://DNS        /SchedulingSvc")
        String sitesFileName);

    /**
     * Get all VHA sites
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.RegionArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/getVHA")
    @WebResult(name = "getVHAResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "getVHA", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVHA")
    @ResponseWrapper(localName = "getVHAResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.GetVHAResponse")
    public RegionArray getVHA();

    /**
     * Connect to a single VistA system
     * 
     * @param sitelist
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.DataSourceArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/connect")
    @WebResult(name = "connectResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "connect", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.Connect")
    @ResponseWrapper(localName = "connectResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.ConnectResponse")
    public DataSourceArray connect(
        @WebParam(name = "sitelist", targetNamespace = "http://DNS        /SchedulingSvc")
        String sitelist);

    /**
     * Log onto a single VistA system
     * 
     * @param pwd
     * @param username
     * @param context
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.UserTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/login")
    @WebResult(name = "loginResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "login", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.Login")
    @ResponseWrapper(localName = "loginResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.LoginResponse")
    public UserTO login(
        @WebParam(name = "username", targetNamespace = "http://DNS        /SchedulingSvc")
        String username,
        @WebParam(name = "pwd", targetNamespace = "http://DNS        /SchedulingSvc")
        String pwd,
        @WebParam(name = "context", targetNamespace = "http://DNS        /SchedulingSvc")
        String context);

    /**
     * Disconnect from all connected Vista systems.
     * 
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.TaggedTextArray
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/disconnect")
    @WebResult(name = "disconnectResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "disconnect", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.Disconnect")
    @ResponseWrapper(localName = "disconnectResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.DisconnectResponse")
    public TaggedTextArray disconnect();

    /**
     * Select a patient at logged in site. DFN is the Patient's IEN.
     * 
     * @param dfn
     * @return
     *     returns com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.PatientTO
     */
    @WebMethod(action = "http://DNS        /SchedulingSvc/select")
    @WebResult(name = "selectResult", targetNamespace = "http://DNS        /SchedulingSvc")
    @RequestWrapper(localName = "select", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.Select")
    @ResponseWrapper(localName = "selectResponse", targetNamespace = "http://DNS        /SchedulingSvc", className = "com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SelectResponse")
    public PatientTO select(
        @WebParam(name = "DFN", targetNamespace = "http://DNS        /SchedulingSvc")
        String dfn);

}
